 ; Ŀ
 ;   Tara - make text fit in a box.                                        
 ;   Copyright 1995, 1999, 2002, 2004 - 2010 by Rocket Software Ltd.       
 ;                                                                         
 ; 

 ; Ŀ
 ;   3T - make a column of text into a single string.                      
 ;   Arguments: SS, an ss of text enames.                                  
 ;   Calls nothing, erases the all but the first line of text,             
 ;   returns a list: (ename string).                                       
 ; 
 (DEFUN 3T (ss / orlst esav astra enam entt)
 ; Ŀ
 ;   Get the text enames as a list in vertical order.                      
 ; 
  (setq orlst (vtol ss "" t))
 ; Ŀ
 ;   Save the ename of the highest one.                                    
 ; 
  (setq esav (car orlst))
  (setq orlst (cdr orlst))
  (setq astra (cdr (setq asoc1 (assoc 1 (entget esav)))))
 ; Ŀ
 ;   Extract the strings from the others, kill them.                       
 ; 
  (while (setq enam (car orlst))
         (setq orlst (cdr orlst))
         (setq astra (strcat astra " " (cdr (assoc 1 (entget enam)))))
         (entdel enam))
 (list esav astra))
 ; Ŀ
 ;   3T end.                                                               
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 
 
 ; Ŀ
 ;   Grout - Text/Attdef grdraw outliner.                                  
 ;   Arguments: SS, a selection set of textlike things.                    
 ;              Gbox, the grdraw colour, if nil then don't draw a box.     
 ;              Offdis, the offset distance for text.                      
 ;   Returns a list of four corner points, cw from top left.               
 ;   Rewritten 2010.10.10 to take Offdis as an argument.                   
 ; 
 (DEFUN GROUT (ss gbox offdis / num enam typ entt mxlst xmax xmin ymax ymin
                                                                ul ur lr ll)
  (setq num 0)
 ; Ŀ
 ;   Process selection set.                                                
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (if (= typ "INSERT")
             (while (/= (setq typ (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                        "SEQEND")
                    (if (and (= typ "ATTRIB")
                             (/= (cdr (assoc 1 entt)) "")
                             (/= (cdr (assoc 1 entt)) " "))
                        (progn
                             (setq mxlst (cron enam offdis))
                             (if xmax
                                 (setq xmax (max xmax (car mxlst)))
                                 (setq xmax (car mxlst)))
                             (if xmin
                                 (setq xmin (min xmin (cadr mxlst)))
                                 (setq xmin (cadr mxlst)))
                             (if ymax
                                 (setq ymax (max ymax (caddr mxlst)))
                                 (setq ymax (caddr mxlst)))
                             (if ymin
                                 (setq ymin (min ymin (cadddr mxlst)))
                                 (setq ymin (cadddr mxlst)))))))
         (if (or (= typ "TEXT") (= typ "ATTDEF"))
             (progn
                  (setq mxlst (cron enam offdis))
                  (if xmax
                      (setq xmax (max xmax (car mxlst)))
                      (setq xmax (car mxlst)))
                  (if xmin
                      (setq xmin (min xmin (cadr mxlst)))
                      (setq xmin (cadr mxlst)))
                  (if ymax
                      (setq ymax (max ymax (caddr mxlst)))
                      (setq ymax (caddr mxlst)))
                  (if ymin
                      (setq ymin (min ymin (cadddr mxlst)))
                      (setq ymin (cadddr mxlst))))))
 ; Ŀ
 ;   Make the corner point coordinates.                                    
 ; 
  (setq ul (list xmin ymax))
  (setq ur (list xmax ymax))
  (setq lr (list xmax ymin))
  (setq ll (list xmin ymin))
 ; Ŀ
 ;   Now draw the polyline around the outer extent points.                 
 ; 
  (if gbox
      (progn
           (grdraw ul ur gbox)
           (grdraw ur lr gbox)
           (grdraw lr ll gbox)
           (grdraw ll ul gbox)))
 (list ul ur lr ll))
 ; Ŀ
 ;   Grout end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Twidd - find the width of a hypothetical text string.                 
 ;   Arguments: Entt, the prototype text entity data list.                 
 ;              Stra, the string.                                          
 ;   Returns a length in drawing units.                                    
 ; 
 (DEFUN TWIDD (entt stra / tblist cc dd bwidth)
  (setq entt (subst (cons 1 stra) (assoc 1 entt) entt))
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Twidd end.                                                            
 ; 

 ; Ŀ
 ;   Txl: divide a string at spaces into substrings at or below a          
 ;   certain length.  Strings can exceed this length only if there is      
 ;   no way to split them.                                                 
 ;   Arguments: Str, the string to divide up.                              
 ;              Idealn, the desired physical (...) length.                 
 ;              Entt, the pattern text entity data.                        
 ;              Mapat, a match pattern for a string not to split or nil.   
 ;   Returns a list of strings.                                            
 ;   Calls Splat.                                                          
 ; 
 (DEFUN TXL (str idealn entt mapat / strlst num base sub malist)
 ; Ŀ
 ;   Call Splat to make the string into a list of strings.                 
 ; 
  (setq strlst (splat " " str))
  (setq num 0)
  (setq base "")
  (while (setq sub (nth num strlst))
 ; Ŀ
 ;   Cond 1. The base string is empty and the next one is too long.        
 ; 
         (cond ((and (= base "")
                     (< idealn (twidd entt sub)))
                (setq malist (cons sub malist))
                (setq num (1+ num))
                (setq base ""))
 ; Ŀ
 ;   Cond 1a. the next string matches the pattern string.                  
 ; 
               ((and mapat (wcmatch sub mapat))
                (if (= base "")
                    (setq malist (cons sub malist))
                    (setq malist (cons sub (cons base malist))))
                (setq num (1+ num))
                (setq base ""))
 ; Ŀ
 ;   Cond 2. The base string is empty and sub is not too long.             
 ; 
               ((and (= base "")
                     (>= idealn (twidd entt sub)))
                (setq base sub)
                (setq num (1+ num)))
 ; Ŀ
 ;   Cond 3. The base string + sub are not too long.                       
 ; 
               ((>= idealn (twidd entt (strcat base " " sub)))
                (setq base (strcat base " " sub))
                (setq num (1+ num)))
 ; Ŀ
 ;   Cond 3a. Sub is a single digit.                                       
 ; 
               ((= (strlen sub) 1)
                (setq base (strcat base " " sub))
                (setq num (1+ num)))
 ; Ŀ
 ;   Cond 4. The base string + sub are too long.                           
 ; 
               ((< idealn (twidd entt (strcat base " " sub)))
                (setq malist (cons base malist))
                (setq base ""))))
 ; Ŀ
 ;   If base isn't nil, add it to the list.                                
 ; 
  (if base (setq malist (cons base malist)))
 ; Ŀ
 ;   Return the list of strings.                                           
 ; 
 (reverse malist))
 ; Ŀ
 ;   Subroutine Txl end.                                                   
 ; 

 ; Ŀ
 ;   Subroutine VBMLX - middle left rejustify a column of text.            
 ;   Arguments: SS, a selection set of text and attdefs.                   
 ;              Xa, a left point.                                          
 ;   Returns the empty wrapper that used to contain reality.               
 ;   This is the version that moves text entities along their x axis to    
 ;   the x alignment point.  For a straight horizontal move see the Vbml   
 ;   subroutine in Px.lsp.                                                 
 ; 
 (DEFUN VBMLX (ss xa / entt txang obliq dnang xb num enam pa typ txht pelv pb
                                                                           ll)
 ; Ŀ
 ;   Use the text angle of the first text entity as the angle for all.     
 ; 
  (setq entt (entget (ssname ss 0)))
  (setq txang (cdr (assoc 50 entt)))
  (if (null (setq obliq (cdr (assoc 51 entt))))
      (setq obliq 0))
  (setq dnang (- txang (/ pi 2) obliq))
  (setq xb (polar xa dnang 100))
 ; Ŀ
 ;   For each entity find its angle and the intersection of its baseline   
 ;   with a line from xa at dnang, the text down angle, and move it there. 
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))
 ; Ŀ
 ;   Convert the entity to middle left justified.                          
 ; 
         (setq typ (cdr (assoc 0 entt)))
         (if (= typ "TEXT")
             (if (assoc 73 entt)
                 (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
                 (setq entt (append entt (list (cons 73 2)))))
             (if (assoc 74 entt)
                 (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
                 (setq entt (append entt (list (cons 74 2))))))
         (entmod (subst (cons 72 0) (assoc 72 entt) entt))
 ; Ŀ
 ;   Move it back to the original location.                                
 ; 
         (setq entt (entget enam))
         (setq txht (cdr (assoc 40 entt)))
         (setq txang (cdr (assoc 50 entt)))
         (setq pelv (polar pa (+ txang (/ pi 2)) (/ txht 2)))
         (entmod (subst (cons 11 pelv) (assoc 11 entt) entt))
 ; Ŀ
 ;   Move it into the correct location along its own horizontal axis.      
 ; 
         (setq entt (entget enam))
         (setq pa (cdr (assoc 11 entt)))
         (setq pb (polar pa txang 100))
         (setq ll (inters xa xb pa pb nil))
         (entmod (subst (cons 11 ll) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Subroutine Vbmlx end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Veeb - add text strings below an existing one.             
 ;   Arguments: Enam, the existing text entity name.                       
 ;              Strlst, a list of strings.                                 
 ;   Calls its Granny, Returns an ss of the existing and new text.         
 ; 
 (DEFUN VEEB (enam strlst / ss entt pa incr vdis rota str num pb elast)
  (setq ss (ssadd enam))
  (setq entt (entget enam))
  (setq pa (cdr (assoc 10 entt)))
  (setq incr (* 1.65 (cdr (assoc 40 entt))))
  (setq vdis incr)
  (setq rota (cdr (assoc 50 entt)))
  (setq str (car strlst))
  (entmod (subst (cons 1 str) (assoc 1 entt) entt))
  (setq num 1)
  (while (setq str (nth num strlst))
         (setq num (1+ num))
         (setq pb (polar pa (+ rota (* pi 1.5)) vdis))
         (command ".copy" enam "" pa pb)
         (setq elast (entlast))
         (ssadd elast ss)
         (setq entt (entget elast))
         (entmod (subst (cons 1 str) (assoc 1 entt) entt))
         (setq vdis (+ vdis incr)))
 ss)
 ; Ŀ
 ;   Subroutine Veeb end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Veni - squeeze or stretch text as required.                
 ;   Arguments: Enam, a text ename.                                        
 ;              Width, a desired width.                                    
 ;              Txtscl, a desired width scale factor.                      
 ;   Calls Wits.                                                           
 ;   Returns nothing.                                                      
 ; 
 (DEFUN Veni (enam width txtscl / entt realwd widscl prev41 scalfc)
 ; Ŀ
 ;   Get the text entity data.                                             
 ; 
  (setq entt (entget enam))
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
  (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
  (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ; 
  (if (and (> realwd width) (not (equal realwd width 0.1)))
 ; Ŀ
 ;   If the actual width is greater than the allowed width in the          
 ;   sublist, then adjust the width scale factor to make it fit.           
 ;   Wait: must also check to see if the width scale is greater than the   
 ;   ideal - if the attribute is too wide and the width scale is too       
 ;   large, then shrinking the attribute to fit may result in it just      
 ;   filling the space but still being too wide.                           
 ; 
      (progn
 ; Ŀ
 ;   Compare the actual width scale to the ideal width scale.              
 ; 
           (if (<= widscl txtscl)
 ; Ŀ
 ;   If the actual is less than or equal to the ideal, then make it fit.   
 ; 
               (progn
                    (setq scalfc (/ width realwd))
                    (setq widscl (* widscl scalfc))
                    (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   If the actual width scale is greater than the ideal, see if the       
 ;   attribute will be too wide if if set to the ideal.                    
 ;   If so then squash to fit, if not then set to the ideal.               
 ; 
               (progn
                    (if (> (* realwd (/ txtscl widscl)) width)
 ; Ŀ
 ;   Squash to fit.                                                        
 ; 
                        (progn
                             (setq scalfc (/ width realwd))
                             (setq widscl (* widscl scalfc))
                             (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Set to the ideal width scale factor.                                  
 ; 
                        (entmod (subst (cons 41 txtscl) prev41 entt))))))
 ; Ŀ
 ;   Else the actual width is narrower than or equal to the available      
 ;   space.                                                                
 ; 
      (progn
 ; Ŀ
 ;   See if the attribute is narrower than it should be - if setting the   
 ;   width scale factor to the desired value would leave the attribute     
 ;   wider than the allowable space, then increase it to fill the space.   
 ; 
           (if (> (* realwd (/ txtscl widscl)) width)
               (progn
                    (setq scalfc (/ width realwd))
                    (setq widscl (* widscl scalfc))
                    (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
               (entmod (subst (cons 41 txtscl) prev41 entt)))))
 (princ))
 ; Ŀ
 ;   Veni end.                                                             
 ; 

 ; Ŀ
 ;   Vmov - move an ss from one Y coordinate to another.                   
 ;   Takes three arguments, a base y coord, a new y, and the ss name.      
 ;   Returns an old umbrella.                                              
 ; 
 (DEFUN VMOV (pa gnupt ss / dist angg)
  (setq jumps 20)
  (setq dist (/ (- pa gnupt) jumps))
  (repeat jumps
          (command ".move" ss "" "0,0" (list 0 dist))))
 ; Ŀ
 ;   Vmov end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Vtol: returns a list of enames ordered entity position.    
 ;   Arguments: Ss, a selection set of entities to order.                  
 ;              Dir, a direction - if this is either "X" or "Y" then the   
 ;                   entities are assumed to be arrayed in that direction, 
 ;                   if anything else then the routine uses the direction  
 ;                   in which they are most spread out.                    
 ;              Insa, if T and the entity is text or an attribute then     
 ;                    sort based on the insertion point rather than the    
 ;                    ten point.                                           
 ;                                                                         
 ;   This is the latest version: 2006.10.05, which sorts text by           
 ;   insertion point rather than ten point and in which setting the        
 ;   direction to nil doesn't cause a crash.                               
 ;   Also it works with attdefs as well as text.                           
 ;   It should replace all other uses of Vtol and Stol.                    
 ;                                                                         
 ;   Revamped 2009.07.28 to use Apply rather than Eval Cons 'Max List etc. 
 ;   This is less elegant but removes the 256 entity limitation.           
 ;   Also added the ability to sort by either ten point or insertion.      
 ;                                                                         
 ; 
 (DEFUN VTOL (ss dir insa / xposnam yposnam numm ent entt ten xpos ypos xx yy
                            pn maxx minx maxy miny xdif ydif poslst posnam
                                                       direct pos lastt order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (if (and insa (member (cdr (assoc 0 entt)) '("TEXT" "ATTDEF")))
             (setq ten (spit entt))
             (setq ten (cdr (assoc 10 entt))))
         (setq xpos (car ten))
         (setq ypos (cadr ten))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now evaluate the four lists.  The result will be the max and min      
 ;   values for the X and Y lists.                                         
 ; 
  (setq maxx (apply 'max xx))
  (setq minx (apply 'min xx))
  (setq maxy (apply 'max yy))
  (setq miny (apply 'min yy))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set direction variables to match whichever direction was given in     
 ;   the argument, if it was nil then deduce a direction.                  
 ; 
  (cond ((and (= (type dir) 'STR)
              (= (strcase dir) "X"))
          (setq poslst xx)                ; positions from X coord list
          (setq posnam xposnam)           ; position & ename list with X coord
          (setq direct 'min))             ; edit from smallest to largest X
        ((and (= (type dir) 'STR)
              (= (strcase dir) "Y"))
         (setq poslst yy)
         (setq posnam yposnam)
         (setq direct 'max))
        (T
 ; Ŀ
 ;   The default case: figure it out yourself.                             
 ;   Set vert to T if vertical, nil if horizontal.                         
 ;   If not sure, assume vertical.                                         
 ;   Could set strip to Quit and thus do so...                             
 ; 
         (cond ((> xdif ydif)             ; if (Xmax - Xmin) > (Ymax - Ymin)
                (setq poslst xx)          ; positions from X coord list
                (setq posnam xposnam)     ; position & ename list with X coord
                (setq direct 'min))       ; edit from smallest to largest X
               ((< xdif ydif)
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max))
               (T                         ; if not sure then call it vertical
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max)))))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (apply direct poslst))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq lastt (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq lastt (cdr lastt))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq lastt (append (list (nth pos poslst)) lastt))
                (setq pos (1- pos)))
         (setq poslst lastt)      ; poslst becomes lastt
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Vtol end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of a text entity.                    
 ;   Takes one argument: the text entity data list.  Returns a width.      
 ; 
 (DEFUN WITS (entt / tblist cc dd)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (- (car dd) (car cc)))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Tara.                                                                 
 ; 
 (DEFUN C:TARA (/ snapp *error* ss ssav osmo cc rr xa ya incr ptlist lpa1 lpa2
                 leftpt lefdis boxwid txwid enam astr strlis ptlst2 ul ll vmid)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setvar "blipmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if snapp (setvar "snapmode" snapp))
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get an ss of text and/or attdefs.                                     
 ; 
  (prompt "Pick text/attdefs to left justify: ")
  (if (setq ss (ssget '((-4 . "<or")
                        (0 . "text")
                        (0 . "attdef")
                        (-4 . "or>"))))
      (progn
           (setq ssav (ssget "p"))
 ; Ŀ
 ;   Find the desired vertical and horizontal centre point coordinates.    
 ;   (This routine doesn't use the X centrepoint.)                         
 ; 
           (setq osmo (getvar "osmode"))
           (setvar "osmode" 32)
           (setq cc (getpoint "First corner: "))
           (setq rr (getpoint cc "\nOpposite corner or <Return>:"))
           (setvar "osmode" osmo)
           (if rr 
               (progn
                    (setq xa (/ (+ (car cc) (car rr)) 2))
                    (setq ya (/ (+ (cadr cc) (cadr rr)) 2)))
               (progn
                    (setq xa (car cc))
                    (setq ya (cadr cc))))
 ; Ŀ
 ;   Line spacing.                                                         
 ; 
           (setq incr (* 1.65 (cdr (assoc 40 (entget (ssname ss 0))))))
;           (setq incrp (getdist (list xa ya)
;                          (strcat "\nLine spacing <" (rtos incr 2 2) ">:")))
;           (if incrp (setq incr incrp))
 ; Ŀ
 ;   Outline the text, save the corner points.                             
 ; 
           (setq ptlist (grout ss nil 0))
 ; Ŀ
 ;   Find the leftpoint: 2.5 x dimscale from the leftmost corner.          
 ;   Revised: the left distance is 2 on drawings which use a snap of       
 ;   dimscale, 2.5 on drawings which use 2.5 x dimscale.                   
 ; 
           (if rr
              (progn
                   (setq lpa1 (car rr))
                   (setq lpa2 (car cc))
                   (setq leftpt (min lpa1 lpa2)))
              (setq leftpt (car cc)))
           (if (= (car (getvar "snapunit")) (* 2.5 (getvar "dimscale")))
               (setq lefdis (* (getvar "dimscale") 2.5))
               (setq lefdis (* (getvar "dimscale") 2)))
           (setq leftpt (+ leftpt lefdis))
 ; Ŀ
 ;   Find the allowable text width - (box width - leftpoint distance - 2)  
 ; 
           (setq boxwid (abs (- (car cc) (car rr))))
           (setq txwid (- boxwid lefdis 2))
 ; Ŀ
 ;   Suck all of the text into one string.                                 
 ; 
           (setq enam (3t ss))
           (setq astr (cadr enam))
           (setq enam (car enam))
 ; Ŀ
 ;   Split the text into substrings ideally no longer than txwid.          
 ;   (i.e. the length in units of a text entity containing that string.)   
 ;   If the final argument is a string it will be used as a match          
 ;   pattern and any matching string won't be added to another.            
 ; 
;           (setq strlis (txl astr txwid (entget enam) nil))
           (setq strlis (txl astr txwid (entget enam) "*-*"))
 ; Ŀ
 ;   Call veeb to manufacture the stack of new text entities.              
 ; 
           (setq ss (veeb enam strlis))
 ; Ŀ
 ;   Middle-left rejustify the ss.                                         
 ; 
           (vbmlx ss (list leftpt 0))
 ; Ŀ
 ;   Get the new corner points, don't outline the text.                    
 ; 
           (setq ptlst2 (grout ss nil 0))
 ; Ŀ
 ;   Get the text ss vertical midpoint.                                    
 ; 
           (setq ul (cadar ptlst2))
           (setq ll (cadr (nth 3 ptlst2)))
           (setq vmid (/ (+ ul ll) 2))
 ; Ŀ
 ;   Move the new ss centre point to the box centre.                       
 ; 
           (vmov ya vmid ss)
 ; Ŀ
 ;   Make sure that all strings are shorter than the maximum length.       
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (veni enam txwid 1))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))